/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theanomaly.procedures;

import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.mcreator.theanomaly.network.TheAnomalyModVariables;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WeatherEffectsProcedure {
    private static Pattern pattern = Pattern.compile(".*\\.procedures\\..*Procedure\\$CustomDimensionEffects");
    private static List<Consumer<Object[]>> customEffects = null;
    private static Class<?> effects = null;
    private static int ticks = 0;
    private static float partialTick = 0.0f;
    private static ParticleOptions genericParticle = ParticleTypes.f_123761_;
    private static ParticleOptions specialParticle = ParticleTypes.f_123762_;
    private static SoundEvent genericSound = SoundEvents.f_12541_;
    private static SoundEvent specialSound = SoundEvents.f_12542_;

    public static void setParticles(ParticleOptions genericParticle, ParticleOptions specialParticle) {
        WeatherEffectsProcedure.genericParticle = genericParticle;
        WeatherEffectsProcedure.specialParticle = specialParticle;
    }

    public static void setSounds(SoundEvent genericSound, SoundEvent specialSound) {
        WeatherEffectsProcedure.genericSound = genericSound;
        WeatherEffectsProcedure.specialSound = specialSound;
    }

    public static void addEffects(int target, float power, int range, boolean particles, boolean sounds, boolean constant) {
        if (!particles && !sounds) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        float factor = (constant ? 1.0f : level.m_46722_(1.0f)) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        Camera camera = minecraft.f_91063_.m_109153_();
        RandomSource randomSource = RandomSource.m_216335_((long)((long)ticks * 312987231L));
        BlockPos blockPos = new BlockPos(camera.m_90583_());
        boolean effects = false;
        ParticleStatus particleStatus = (ParticleStatus)minecraft.f_91066_.m_231929_().m_231551_();
        boolean visible = particleStatus != ParticleStatus.MINIMAL;
        int amount = (int)(100.0f * factor * factor) / (particleStatus == ParticleStatus.DECREASED ? 2 : 1);
        amount = (int)((float)amount * power);
        for (int i = 0; i < amount; ++i) {
            int iz;
            int ix = randomSource.m_188503_((range << 1) + 1) - range;
            BlockPos surface = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos.m_7918_(ix, 0, iz = randomSource.m_188503_((range << 1) + 1) - range));
            if (surface.m_123342_() <= level.m_141937_() || surface.m_123342_() > blockPos.m_123342_() + range || surface.m_123342_() < blockPos.m_123342_() - range) continue;
            Biome.Precipitation precipitation = ((Biome)level.m_204166_(surface).m_203334_()).m_47530_();
            switch (target) {
                case 1: {
                    effects = precipitation == Biome.Precipitation.RAIN;
                    break;
                }
                case 2: {
                    effects = precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 4: {
                    effects = precipitation == Biome.Precipitation.RAIN || precipitation == Biome.Precipitation.SNOW;
                    break;
                }
                case 8: {
                    effects = precipitation == Biome.Precipitation.NONE;
                    break;
                }
                case 16: {
                    effects = true;
                }
            }
            if (!effects) continue;
            BlockPos ground = surface.m_7495_();
            if (particles && visible) {
                double dx = randomSource.m_188500_();
                double dz = randomSource.m_188500_();
                BlockState blockState = level.m_8055_(ground);
                FluidState fluidState = level.m_6425_(ground);
                VoxelShape voxelShape = blockState.m_60812_((BlockGetter)level, ground);
                double maxHeight = Math.max(voxelShape.m_83290_(Direction.Axis.Y, dx, dz), (double)fluidState.m_76155_((BlockGetter)level, ground));
                ParticleOptions particleOptions = !fluidState.m_205070_(FluidTags.f_13132_) && !blockState.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockState) ? genericParticle : specialParticle;
                level.m_7106_(particleOptions, (double)ground.m_123341_() + dx, (double)ground.m_123342_() + maxHeight, (double)ground.m_123343_() + dz, 0.0, 0.0, 0.0);
            }
            if (!sounds || i != 0 || ground == null || (ticks & 3) <= randomSource.m_188503_(3)) continue;
            if (ground.m_123342_() > blockPos.m_123342_() + 1 && level.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > Mth.m_14143_((float)blockPos.m_123342_())) {
                level.m_104677_(ground, specialSound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                continue;
            }
            level.m_104677_(ground, genericSound, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void setEffects(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        try {
            Class<?> effects = Minecraft.m_91087_().f_91073_.m_104583_().getClass().getSuperclass();
            if (!pattern.matcher(effects.getName()).find()) {
                return;
            }
            if (effects != WeatherEffectsProcedure.effects) {
                WeatherEffectsProcedure.effects = effects;
                customEffects = (List)effects.getField("customEffects").get(null);
            }
            customEffects.add(new Consumer<Object[]>(){

                @Override
                public void accept(Object[] params) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    ClientLevel level = minecraft.f_91073_;
                    Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
                    partialTick = minecraft.getPartialTick();
                    ticks = (Integer)params[1];
                    if (entity != null) {
                        Vec3 pos = entity.m_20318_(partialTick);
                        WeatherEffectsProcedure.execute(null, (LevelAccessor)level);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world) {
        WeatherEffectsProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        if (TheAnomalyModVariables.MapVariables.get((LevelAccessor)world).customweathersfx) {
            WeatherEffectsProcedure.addEffects(1, 1.0f, 5, true, true, false);
        }
    }
}

